//
//  MCDateRangeEnumerator.h
//  MCFoundation
//
//  Created by Michael Clark on 12/10/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <MCFoundation/NSCalendarDate+MCAdditions.h>


typedef enum _MCDateRangeEnumerationMode {
    MCDayDateRangeEnumerationMode        = 1,
    MCWeekDateRangeEnumerationMode,
    MCMonthDateRangeEnumerationMode,
    MCYearDateRangeEnumerationMode
} MCDateRangeEnumerationMode;



@class MCDateRange;

@interface MCDateRangeEnumerator : NSObject {

    @private
	MCDateRange*     __dateRange;
	NSCalendarDate*  __nextStartDate;
	
	MCDateRangeEnumerationMode  __mode;
	MCDayOfWeek                 __weekStartDay;
}

- (id)initWithDateRange: (MCDateRange*)dateRange enumerationMode:(MCDateRangeEnumerationMode)mode; // Uses Sunday as week start day
- (id)initWithDateRange: (MCDateRange*)dateRange enumerationMode:(MCDateRangeEnumerationMode)mode weekStartDay: (MCNSDayOfWeek)startDay;

- (MCDateRange*)nextDateRange;

@end
